<?php

namespace App\Controller;

use App\Actions\PrepareMenuAction;
use App\Requests\MenuRequest;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class PrepareMenuController extends AbstractController
{
    /**
     * Контроллер реструктурирует массив меню добавляя вложенность по значению depth
     * используюя prepareMenu функцию
     * @param MenuRequest $request
     * @param PrepareMenuAction $action
     * @return Response
     */
    #[Route('/prepare/menu', name: 'app_prepare_menu', methods: ['POST'])]
    public function index(MenuRequest $request, PrepareMenuAction $action): Response
    {
        return new JsonResponse($action->act($request->serialise()));
    }
}
