<?php

namespace App\Controller;

use App\Actions\HowDaysToNYAction;
use App\Requests\BeforeNYDateRequest;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HowDaysToNYController extends AbstractController
{
    /**
     * Контролер рассчитывает кол-во дней до нового года используюя howDaysToNy
     * @param BeforeNYDateRequest $request
     * @param HowDaysToNYAction $action
     * @return Response
     */
    #[Route('/howdaystony', name: 'app_how_days_to_n_y')]
    public function index(BeforeNYDateRequest $request, HowDaysToNYAction $action): Response
    {
        return new JsonResponse($action->act($request->serialise()));
    }
}
