<?php

namespace App\Controller;

use App\Actions\DiffDaysAction;
use App\Requests\DiffDaysRequest;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class DiffDaysController extends AbstractController
{
    /**
     * Контроллер вернет кол-во дней между датами
     * @param DiffDaysRequest $request
     * @param DiffDaysAction $action
     * @return Response
     */
    #[Route('/diff/days', name: 'app_diff_days', methods: ['POST'])]
    public function index(DiffDaysRequest $request, DiffDaysAction $action): Response
    {
        $array = $request->serialise();
        return new JsonResponse($action->act($array['startDate'], $array['endDate']));
    }
}
