<?php

namespace App\Controller;

use App\Actions\CountFriday13Action;
use App\Requests\AllFri13Request;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class CountFriday13Controller extends AbstractController
{
    /**
     * git Контроллер вернет все пятницы 13 в году используя countFriday13 функцию
     * @param AllFri13Request $request
     * @param CountFriday13Action $action
     * @return Response
     */
    #[Route('/count/friday13', name: 'app_count_friday13')]
    public function index(AllFri13Request $request, CountFriday13Action $action): Response
    {
        return new JsonResponse($action->act($request->serialise()));
    }
}
