<?php

namespace App\Actions;

use DateTimeImmutable;

class DiffDaysAction
{
    /**
     * Вернет кол-во дней между датами
     * @param DateTimeImmutable $dateStart дата начала
     * @param DateTimeImmutable $dateEnd дата окончания
     * @return int
     * */
    public function act(
        DateTimeImmutable $dateStart,
        DateTimeImmutable $dateEnd
    ): int {
        return (int) $dateStart->diff($dateEnd)->format('%a');
    }
}
