<?php

namespace App\Entity;

use App\Repository\UsersRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: UsersRepository::class)]
class Users
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::GUID)]
    private ?string $uuid = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column]
    private ?bool $isMale = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $birthDay = null;

    #[ORM\Column(length: 255)]
    private ?string $�ф�address = null;

    #[ORM\Column(length: 255)]
    private ?string $surname = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $phone_number = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $email = null;

    /**
     * @var Collection<int, NewsComments>
     */
    #[ORM\OneToMany(targetEntity: NewsComments::class, mappedBy: 'moderator_id')]
    private Collection $news_comments_id_moderate;

    /**
     * @var Collection<int, NewsComments>
     */
    #[ORM\OneToMany(targetEntity: NewsComments::class, mappedBy: 'user_id')]
    private Collection $news_comments_id_comment;

    public function __construct()
    {
        $this->news_comments_id_moderate = new ArrayCollection();
        $this->news_comments_id_comment = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUuid(): ?string
    {
        return $this->uuid;
    }

    public function setUuid(string $uuid): static
    {
        $this->uuid = $uuid;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function isMale(): ?bool
    {
        return $this->isMale;
    }

    public function setMale(bool $isMale): static
    {
        $this->isMale = $isMale;

        return $this;
    }

    public function getBirthDay(): ?\DateTimeImmutable
    {
        return $this->birthDay;
    }

    public function setBirthDay(?\DateTimeImmutable $birthDay): static
    {
        $this->birthDay = $birthDay;

        return $this;
    }

    public function get�ф�address(): ?string
    {
        return $this->�ф�address;
    }

    public function set�ф�address(string $�ф�address): static
    {
        $this->�ф�address = $�ф�address;

        return $this;
    }

    public function getSurname(): ?string
    {
        return $this->surname;
    }

    public function setSurname(string $surname): static
    {
        $this->surname = $surname;

        return $this;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->phone_number;
    }

    public function setPhoneNumber(?string $phone_number): static
    {
        $this->phone_number = $phone_number;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): static
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return Collection<int, NewsComments>
     */
    public function getNewsCommentsIdModerate(): Collection
    {
        return $this->news_comments_id_moderate;
    }

    public function addNewsCommentsIdModerate(NewsComments $newsCommentsIdModerate): static
    {
        if (!$this->news_comments_id_moderate->contains($newsCommentsIdModerate)) {
            $this->news_comments_id_moderate->add($newsCommentsIdModerate);
            $newsCommentsIdModerate->setModeratorId($this);
        }

        return $this;
    }

    public function removeNewsCommentsIdModerate(NewsComments $newsCommentsIdModerate): static
    {
        if ($this->news_comments_id_moderate->removeElement($newsCommentsIdModerate)) {
            // set the owning side to null (unless already changed)
            if ($newsCommentsIdModerate->getModeratorId() === $this) {
                $newsCommentsIdModerate->setModeratorId(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, NewsComments>
     */
    public function getNewsCommentsIdComment(): Collection
    {
        return $this->news_comments_id_comment;
    }

    public function addNewsCommentsIdComment(NewsComments $newsCommentsIdComment): static
    {
        if (!$this->news_comments_id_comment->contains($newsCommentsIdComment)) {
            $this->news_comments_id_comment->add($newsCommentsIdComment);
            $newsCommentsIdComment->setUserId($this);
        }

        return $this;
    }

    public function removeNewsCommentsIdComment(NewsComments $newsCommentsIdComment): static
    {
        if ($this->news_comments_id_comment->removeElement($newsCommentsIdComment)) {
            // set the owning side to null (unless already changed)
            if ($newsCommentsIdComment->getUserId() === $this) {
                $newsCommentsIdComment->setUserId(null);
            }
        }

        return $this;
    }
}
