<?php

namespace App\Entity;

use App\Repository\RestauranTypesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: RestauranTypesRepository::class)]
class RestauranTypes
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    /**
     * @var Collection<int, Restaurants>
     */
    #[ORM\OneToMany(targetEntity: Restaurants::class, mappedBy: 'type_id')]
    private Collection $restaurants_id;

    public function __construct()
    {
        $this->restaurants_id = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return Collection<int, Restaurants>
     */
    public function getRestaurantsId(): Collection
    {
        return $this->restaurants_id;
    }

    public function addRestaurantsId(Restaurants $restaurantsId): static
    {
        if (!$this->restaurants_id->contains($restaurantsId)) {
            $this->restaurants_id->add($restaurantsId);
            $restaurantsId->setTypeId($this);
        }

        return $this;
    }

    public function removeRestaurantsId(Restaurants $restaurantsId): static
    {
        if ($this->restaurants_id->removeElement($restaurantsId)) {
            // set the owning side to null (unless already changed)
            if ($restaurantsId->getTypeId() === $this) {
                $restaurantsId->setTypeId(null);
            }
        }

        return $this;
    }
}
