<?php

namespace App\Entity;

use App\Repository\NewsCommentsRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: NewsCommentsRepository::class)]
class NewsComments
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'news_comments_id')]
    #[ORM\JoinColumn(nullable: false)]
    private ?News $news_id = null;

    #[ORM\Column(nullable: true)]
    private ?bool $moderated = null;

    #[ORM\ManyToOne(inversedBy: 'news_comments_id_moderate')]
    private ?Users $moderator_id = null;

    #[ORM\Column(length: 255)]
    private ?string $user_name = null;

    #[ORM\ManyToOne(inversedBy: 'news_comments_id_comment')]
    private ?Users $user_id = null;

    #[ORM\Column(length: 1000)]
    private ?string $test = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $create_at = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $update_at = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNewsId(): ?News
    {
        return $this->news_id;
    }

    public function setNewsId(?News $news_id): static
    {
        $this->news_id = $news_id;

        return $this;
    }

    public function isModerated(): ?bool
    {
        return $this->moderated;
    }

    public function setModerated(?bool $moderated): static
    {
        $this->moderated = $moderated;

        return $this;
    }

    public function getModeratorId(): ?Users
    {
        return $this->moderator_id;
    }

    public function setModeratorId(?Users $moderator_id): static
    {
        $this->moderator_id = $moderator_id;

        return $this;
    }

    public function getUserName(): ?string
    {
        return $this->user_name;
    }

    public function setUserName(string $user_name): static
    {
        $this->user_name = $user_name;

        return $this;
    }

    public function getUserId(): ?Users
    {
        return $this->user_id;
    }

    public function setUserId(?Users $user_id): static
    {
        $this->user_id = $user_id;

        return $this;
    }

    public function getTest(): ?string
    {
        return $this->test;
    }

    public function setTest(string $test): static
    {
        $this->test = $test;

        return $this;
    }

    public function getCreateAt(): ?\DateTimeImmutable
    {
        return $this->create_at;
    }

    public function setCreateAt(\DateTimeImmutable $create_at): static
    {
        $this->create_at = $create_at;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeInterface
    {
        return $this->update_at;
    }

    public function setUpdateAt(\DateTimeInterface $update_at): static
    {
        $this->update_at = $update_at;

        return $this;
    }
}
