<?php

namespace App\Shared\Collection;

use JsonSerializable;
use Ramsey\Collection\AbstractCollection;

class DtoCollection extends AbstractCollection implements JsonSerializable
{
    protected function __construct(
        private readonly string $collectionType,
        array $data = []
    ) {
        parent::__construct($data);
    }

    /** @return string */
    public function getType(): string
    {
        return $this->collectionType;
    }

    public function jsonSerialize(): array
    {
        return $this->data;
    }
}
