<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Collection\TagCollection;
use App\Restaurants\Dto\TagDto;
use App\Shared\Collection\StringCollection;
use JsonException;
use Ramsey\Collection\Collection as RamseyCollection;

class TagDtoFactory
{
    /**
     * @param string $json
     * @return TagCollection<TagDto>
     * @throws JsonException
     */
    public function createCollection(string $json): TagCollection
    {
        $jsonCollection = new RamseyCollection(
            'array',
            json_decode(
                $json,
                true,
                512,
                JSON_THROW_ON_ERROR
            )
        );

        $tagCollection = new TagCollection();

        foreach ($jsonCollection as $name => $jsonItem) {
            $tagCollection->add(
                new TagDto($name, new StringCollection($jsonItem))
            );
        }

        return $tagCollection;
    }
}
