<?php

namespace App\News\UseCase;

use App\News\Request\NewsListingRequest;
use App\News\Service\NewsPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class NewsGetListingUseUseCase
{
    public function __construct(
        private readonly NewsPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(NewsListingRequest $request): JsonResponse {
        try {
            return new JsonResponse(
                $this->prepareRequestService->bornListDto($request)
            );
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
