<?php

namespace App\News\Controller;

use App\News\Request\NewsDetailRequest;
use App\News\Request\NewsListingRequest;
use App\News\UseCase\NewsGetDetailMainUseCase;
use App\News\UseCase\NewsGetDetailUseCase;
use App\News\UseCase\NewsGetListingUseUseCase;
use App\News\UseCase\NewsGetMainUseCase;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/news')]
class NewsController extends AbstractController
{
    public function __construct(
        private readonly NewsGetListingUseUseCase $getListingUseCase,
        private readonly NewsGetDetailUseCase $getDetailNews,
        private readonly NewsGetMainUseCase $getMainNews,
        private readonly NewsGetDetailMainUseCase $getDetailMainNews,
    ) {
    }

    #[Route('/', name: 'news', methods: ['GET'])]
    public function news(NewsListingRequest $request): JsonResponse
    {
        return $this->getListingUseCase->execute($request);
    }

    #[Route('/mainNews', name: 'mainNews', methods: ['GET'])]
    public function mainNews(): JsonResponse
    {
        return $this->getMainNews->execute();
    }

    #[Route('/search', name: 'searchNews', methods: ['GET'])]
    public function detailMainNews(): JsonResponse
    {
        return $this->getDetailMainNews->execute();
    }

    #[Route('/{detailId}', name: 'oneNews', methods: ['GET'])]
    public function oneNews(NewsDetailRequest $request): JsonResponse
    {
        return $this->getDetailNews->execute($request);
    }
}
