<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use function App\Repository\countFriday13;

class CountFriday13Controller extends AbstractController
{
    /**
     * git Контроллер вернет все пятницы 13 в году используя countFriday13 функцию
     * @param Request $request
     * @return Response
     */
    #[Route('/count/friday13', name: 'app_count_friday13')]
    public function index(Request $request): Response
    {
        $year = $request->toArray()['year'];

        $returnableArray = countFriday13($year);

        return new JsonResponse($returnableArray, Response::HTTP_OK);
    }
}
