<?php

namespace App\Shared\Error;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\HttpException;

class BaseError extends HttpException
{
    public function __construct(
        int $statusCode = Response::HTTP_INTERNAL_SERVER_ERROR,
        string $message = 'Something bad happening',
        ErrorCode $code = ErrorCode::NotExcepted
    ) {
        parent::__construct(
            statusCode: $statusCode,
            message: $message,
            code: $code->value
        );
    }
}
