<?php

namespace App\Shared\DtoFactory;

use App\Shared\Collection\FileCollection;
use App\Shared\Dto\FileDto;
use App\Shared\Entity\File;
use Doctrine\Common\Collections\Collection;

class FileDtoFactory
{
    public function create(File $file): FileDto
    {
        return new FileDto(
            id: $file->getId(),
            name: $file->getName(),
            description: $file->getDescription(),
            size: $file->getSize(),
            type: $file->getType(),
            url: $file->getUrl(),
        );
    }

    /**
     * @param Collection<File> $files
     * @return FileCollection<FileDto>
     */
    public function createCollection(Collection $files): FileCollection
    {
        $filesDto = $files->map(function (File $file) {
            return $this->create($file);
        });

        return new FileCollection(
            $filesDto->toArray()
        );
    }
}
