<?php

namespace App\Shared\DtoFactory;

use App\Shared\Dto\ErrorDto;
use App\Shared\Error\BaseError;

class ErrorDtoFactory
{
    public function create(BaseError $error): ErrorDto
    {
        return new ErrorDto(
            status: $error->getStatusCode(),
            message: $error->getMessage(),
            code: $error->getCode(),
        );
    }
}
