<?php

namespace App\Restaurants\UseCase;

use App\Restaurants\Request\RestaurantListingRequest;
use App\Restaurants\Service\RestaurantPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class RestaurantGetListingUseCase
{
    public function __construct(
        private readonly RestaurantPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(RestaurantListingRequest $request): JsonResponse
    {
        try {
            return new JsonResponse(
                $this->prepareRequestService->bornListDto($request)
            );
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
