<?php

namespace App\Restaurants\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Component\Validator\Constraints\Uuid;

class RestaurantPartUpdateRequest extends AbstractRequest
{
    #[Uuid]
    public $id;

    #[Uuid]
    public $type_id;

    #[Uuid]
    public $settlement_id;

    #[Uuid]
    public $preview_image_id;

    #[Uuid]
    public $detail_image_id;

    #[Type('bool')]
    public $active;

    #[Type('string')]
    public $name;

    #[Type('string')]
    public $code;

    #[Type('string')]
    public $description;

    #[Type('string')]
    public $check;

    #[Type('string')]
    public $check_info;


    #[Type('string')]
    public $phone;

    #[Type('string')]
    public $email;

    #[Type('string')]
    public $address;

    #[Type('string')]
    public $tags;

    #[Type('string')]
    public $site;

    #[Type('string')]
    public $coordinates;

    #[Type('string')]
    public $how_to_find;

    #[Type('array')]
    #[All(
        new UUid(),
    )]
    public $kitchens_id;

    #[Type('array')]
    #[All(
        new UUid(),
    )]
    public $gallery_id;
}