<?php

namespace App\Restaurants\Request;

use App\Shared\Service\ValidationService;
use Symfony\Component\HttpFoundation\Request;

class RestaurantListingRequest
{
    public int $page = 1;
    public int $limit = 12;
    public ?string $restaurant_type_id = null;
    public ?string $kitchen_id = null;

    public function __construct(
        private readonly ValidationService $validation,
    ) {
        $this->populate();
        $this->checkAndCorrectParams();
    }

    private function checkAndCorrectParams(): void
    {
        if (!$this->validation->isPageValid($this->page)) {
            $this->page = 1;
        }

        if (!$this->validation->isLimitValid($this->limit)) {
            $this->limit = 12;
        }

        if (!$this->validation->isUuidValid($this->restaurant_type_id)) {
            $this->restaurant_type_id = null;
        }

        if (!$this->validation->isUuidValid($this->kitchen_id)) {
            $this->kitchen_id = null;
        }
    }

    private function populate(): void
    {
        foreach (
            $this->getRequest()->query->getIterator() as $property => $value
        ) {
            if (property_exists($this, $property)) {
                $this->{$property} = $value;
            }
        }
    }

    public function getRequest(): Request
    {
        return Request::createFromGlobals();
    }
}