<?php

namespace App\News\Controller;

use App\News\Request\NewsCreateRequest;
use App\News\Request\NewsDetailRequest;
use App\News\Request\NewsFullUpdateRequest;
use App\News\Request\NewsListingRequest;
use App\News\Request\NewsPartUpdateRequest;
use App\News\UseCase\NewsCreateUseCase;
use App\News\UseCase\NewsDeleteUseCase;
use App\News\UseCase\NewsFullUpdateUseCase;
use App\News\UseCase\NewsGetDetailMainUseCase;
use App\News\UseCase\NewsGetDetailUseCase;
use App\News\UseCase\NewsGetListingUseUseCase;
use App\News\UseCase\NewsGetMainUseCase;
use App\News\UseCase\NewsPartUpdateUseCase;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/news')]
class NewsController extends AbstractController
{
    public function __construct(
        private readonly NewsGetListingUseUseCase $getListingUseCase,
        private readonly NewsGetDetailUseCase $getDetailUseCase,
        private readonly NewsGetMainUseCase $getMainUseCase,
        private readonly NewsGetDetailMainUseCase $getDetailMainUseCase,
        private readonly NewsCreateUseCase $createUseCase,
        private readonly NewsFullUpdateUseCase $fullUpdateUseCase,
        private readonly NewsPartUpdateUseCase $partUpdateUseCase,
        private readonly NewsDeleteUseCase $deleteUseCase,
    ) {
    }

    #[Route('/', name: 'news', methods: ['GET'])]
    public function news(NewsListingRequest $request): JsonResponse
    {
        return $this->getListingUseCase->execute($request);
    }

    #[Route('/mainNews', name: 'mainNews', methods: ['GET'])]
    public function mainNews(): JsonResponse
    {
        return $this->getMainUseCase->execute();
    }

    #[Route('/search', name: 'searchNews', methods: ['GET'])]
    public function detailMainNews(): JsonResponse
    {
        return $this->getDetailMainUseCase->execute();
    }

    #[Route('/{detailId}', name: 'oneNews', methods: ['GET'])]
    public function oneNews(NewsDetailRequest $request): JsonResponse
    {
        return $this->getDetailUseCase->execute($request);
    }

    #[Route('/create', name: 'createNews', methods: ['POST'])]
    public function createNews(NewsCreateRequest $request): Response
    {
        return $this->createUseCase->execute($request);
    }

    #[Route('/update', name: 'updateNews', methods: ['PUT'])]
    public function fillUpdateNews(NewsFullUpdateRequest $request): Response
    {
        return $this->fullUpdateUseCase->execute($request);
    }

    #[Route('/partUpdate', name: 'partUpdateNews', methods: ['PATCH'])]
    public function partUpdateNews(NewsPartUpdateRequest $request): Response
    {
        return $this->partUpdateUseCase->execute($request);
    }

    #[Route('/delete/{detailId}', name: 'deleteNews', methods: ['DELETE'])]
    public function deleteNews(NewsDetailRequest $request): Response
    {
        return $this->deleteUseCase->execute($request);
    }
}
