<?php

namespace App\Tests\RestaurantTests\Controller;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class RestaurantsControllerTests extends WebTestCase
{
    // Тест restaurant
    public function testRightUuid(): void
    {
        $client = static::createClient();
        $client->request(
            'GET',
            '/api/v1/restaurants/00000000-0000-0000-0000-000000000000'
        );
        $data = $client->getResponse()->getContent();

        self::assertResponseIsSuccessful();

        self::assertStringContainsString(
            '"id":"00000000-0000-0000-0000-000000000000","name":"Restaurant1","code":"restaurant_1","coordinates":"0.0.0.0","type":{"id":"00000000-0000-0000-0000-000000000001","name":"Type2","code":"type_2"},"check":"check1","check_info":"check1Info","kitchen":[{"id":"00000000-0000-0000-0000-000000000000","name":"Kitchen1","code":"kitchen_1"}],"phone":{"phone1":"+7000000000"},"email":{"email":"base@gmail.com"},"address":{"address":"somewhere"},"tags":[{"name":"setTags1","list":["tag1","tag2","tag3"]},{"name":"setTags2","list":["tag1","tag2","tag3"]}],"site":"www.restaurant.ru","image":{"id":"00000000-0000-0000-0000-000000000001","name":"image1","description":"description","size":512,"type":"jpg","url":"\/here\/"},"gallery":[]}',
            $data,
            'Полученная детальная новость инккоректена'
        );
    }

    public function testNonExistedUuid(): void
    {
        $client = static::createClient();
        $client->request(
            'GET',
            '/api/v1/restaurants/00000000-0000-0000-0000-000000000005'
        );

        self::assertResponseStatusCodeSame(404);
    }

    public function testCorruptUuid(): void
    {
        $client = static::createClient();
        $client->request('GET', '/api/v1/restaurants/net-a-uuid');

        self::assertResponseStatusCodeSame(400);
    }

    //Тест restaurants
    public function testNullRequest(): void
    {
        $client = static::createClient();
        $client->request('GET', '/api/v1/restaurants/');
        $data = $client->getResponse()->getContent();

        self::assertResponseIsSuccessful();

        /** Проверка пагинации */
        self::assertStringContainsString(
            '"pagination":{"currentPage":1,"pages":1,"pageSize":12}',
            $data,
            'Пагинация инкорректна при пустом реквесте'
        );

        /** Проверка получемых новостей */
        self::assertStringContainsString(
            '"list":[{"id":"00000000-0000-0000-0000-000000000000","name":"Restaurant1","detailLink":"api\/v1\/restaurants\/00000000-0000-0000-0000-000000000000","code":"restaurant_1","type":{"id":"00000000-0000-0000-0000-000000000001","name":"Type2","code":"type_2"},"check":"check1","image":{"id":"00000000-0000-0000-0000-000000000001","name":"image1","description":"description","size":512,"type":"jpg","url":"\/here',
            $data,
            'Полученный список новостей инккоректен при пустом реквесте'
        );

        /** Проверка фильтров */
        self::assertStringContainsString(
            '"filterVariants":{"type":[{"id":"00000000-0000-0000-0000-000000000000","name":"Type1","code":"type_1"},{"id":"00000000-0000-0000-0000-000000000001","name":"Type2","code":"type_2"}],"kitchen":[{"id":"00000000-0000-0000-0000-000000000000","name":"Kitchen1","code":"kitchen_1"}]}',
            $data,
            'Пагинация инкорректна при пустом реквесте'
        );
    }

    public function testNegativePagination(): void
    {
        $client = static::createClient();
        $client->request('GET', '/api/v1/restaurants/?page=-10&limit=-10');
        $data = $client->getResponse()->getContent();

        self::assertResponseIsSuccessful();

        /** Проверка пагинации */
        self::assertStringContainsString(
            '"pagination":{"currentPage":1,"pages":1,"pageSize":12}',
            $data,
            'Пагинация инкорректна при негативных значениях'
        );
    }

    public function testPageOverListCountPagination(): void
    {
        $client = static::createClient();
        $client->request('GET', '/api/v1/restaurants/?page=14');
        $data = $client->getResponse()->getContent();

        self::assertResponseIsSuccessful();

        /** Проверка пагинации */
        self::assertStringContainsString(
            '"pagination":{"currentPage":1,"pages":1,"pageSize":12}',
            $data,
            'Пагинация инкорректна при позитивных значениях'
        );
    }

    public function testRightFilter(): void
    {
        $client = static::createClient();
        $client->request(
            'GET',
            '/api/v1/news/?restaurant_type_id=00000000-0000-0000-0000-000000000000'
        );

        self::assertResponseIsSuccessful();
    }

    public function testCorruptFilter(): void
    {
        $client = static::createClient();
        $client->request(
            'GET',
            '/api/v1/news/?restaurant_type_id=looks-like-not-a-UUId'
        );

        self::assertResponseStatusCodeSame(200);
    }
}