<?php

namespace App\Shared\DtoFactory;

use App\Shared\Dto\PaginationDto;

class PaginationDtoFactory
{
    public function create(int $page, int $limit, int $total): PaginationDto
    {
        $pageSize = $limit > 0 ? $limit : 12;
        $pages = ceil($total / $pageSize);
        $page = ($page > 1) && ($page <= $pages) ? $page : 1;

        return new PaginationDto($page, $pages, $pageSize);
    }
}
