<?php

namespace App\News\Dto;

use App\Shared\Abstraction\AbstractListingElementDto;
use App\Shared\Dto\FileDto;

class NewsListingElementDto extends AbstractListingElementDto
{
    /**
     * @param string $id
     * @param string $name
     * @param string $createAt
     * @param string $detailLink
     * @param string|null $description
     * @param FileDto|null $image Превью
     */
    public function __construct(
        public string $id,
        public string $name,
        public string $createAt,
        public string $detailLink,
        public ?string $description = null,
        public ?FileDto $image = null,
    ) {
    }
}
