<?php

namespace App\News\Dto;

use App\Shared\Abstraction\AbstractDetailElement;
use App\Shared\Dto\FileDto;

class NewsDetailElementDto extends AbstractDetailElement
{
    /**
     * @param string $id
     * @param string $name
     * @param string $description
     * @param string $createAt
     * @param string|null $text
     * @param FileDto|null $image Преаью
     */
    public function __construct(
        public string $id,
        public string $name,
        public string $description,
        public string $createAt,
        public ?string $text = null,
        public ?FileDto $image = null,
    ) {
    }
}
