<?php

namespace App\News\Controller;

use App\News\Service\NewsPrepareResponseService;
use App\Shared\Abstraction\AbstractController;
use App\Shared\DtoFactory\ErrorDtoFactory;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Attribute\MapQueryParameter;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/news')]
class NewsController extends AbstractController
{
    public function __construct(
        ErrorDtoFactory $errorFactory,
        private readonly NewsPrepareResponseService $responsePrepareService,
    ) {
        parent::__construct($errorFactory);
    }

    #[Route('/', name: 'news', methods: ['GET'])]
    public function news(
        #[MapQueryParameter] int $page = 1,
        #[MapQueryParameter] int $limit = 12,
        #[MapQueryParameter] string $news_category = null
    ): JsonResponse {
        return $this->handleListing(
            $this->responsePrepareService,
            $page,
            $limit,
            $news_category,
        );
    }

    #[Route('/mainNews', name: 'mainNews', methods: ['GET'])]
    public function mainNews(): JsonResponse
    {
        return new JsonResponse($this->responsePrepareService->bornMainNews());
    }

    #[Route('/search', name: 'searchNews', methods: ['GET'])]
    public function search(): JsonResponse
    {
        return new JsonResponse(
            $this->responsePrepareService->bornDetailMainNews()
        );
    }

    #[Route('/{detailId}', name: 'oneNews', methods: ['GET'])]
    public function oneNews(
        #[MapQueryParameter] string $detailId = null
    ): JsonResponse {
        return $this->handleDetailElement(
            $this->responsePrepareService,
            $detailId,
        );
    }
}
