<?php

namespace App\Requests;

use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Collection;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Optional;
use Symfony\Component\Validator\Constraints\Type;

class UsersRequest extends BaseRequest
{
    #[Type('integer')]
    #[NotBlank]
    public $id;

    #[Type('array')]
    #[All(
        constraints: new Collection(fields: [
                'id' => [
                    new Type('integer'),
                    new NotBlank(),
                ],
                'name' => [
                    new Type('string'),
                    new NotBlank(),
                ],
                'age' => new Optional([
                    new Type('integer'),
                ])
            ])
    )]
    public $users;

    /**
     * @return array
     */
    public function serialise(): array
    {
        return [
            'id' => $this->id,
            'users' => $this->users,
        ];
    }
}