<?php

namespace App\Requests;

use DateTimeImmutable;
use Symfony\Component\Validator\Constraints\Date;
use Symfony\Component\Validator\Constraints\Type;

class BeforeNYDateRequest extends BaseRequest
{
    #[Date()]
    #[Type('string')]
    public $date;

    public function serialise(): mixed
    {
        return new DateTimeImmutable($this->date);
    }
}
